#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	[TestFixture]
	public class DAL_AuditTrail : BaseTest 
	{
		//Subtract 5 minutes for server time inaccuracies
		private DateTime _startDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode).AddMinutes(-5);
		private DateTime _endDate = DateTime.Now.AddDays(1);
		private DateTime _invalidStart = DateTime.Now.AddYears(1);
		private DateTime _invalidEnd = DateTime.Now.AddYears(-1);
		

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._endDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode).AddMinutes(5);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetPatientAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientGuid FROM Patient");

			this.PerformUpdate(TABLES.Patient.TableName, TABLES.Patient.PatientGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetPatientAudit(this._startDate, this._endDate);
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetPatientAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetPatientAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTRAudit_Pass()
		{
			Guid recGuid = Guid.Empty;
			Guid pGuid = Guid.Empty;
			string recordStatusCode = "";

			string sqlText = "SELECT TOP 1 PatientGuid FROM Patient";
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sqlText, true);

			if (dtTemp.Rows.Count > 0)
			{
				pGuid = (Guid) dtTemp.Rows[0][0];
			}

			sqlText = "SELECT TOP 1 PatientTransfusionRequirementGuid, RecordStatusCode FROM PatientTransfusionRequirement WHERE CreateDivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'";
			dtTemp = UnitTestUtil.RunSQLGetDataTable(sqlText, true);

			if (dtTemp.Rows.Count > 0)
			{
				recGuid = (Guid) dtTemp.Rows[0][0];
				recordStatusCode = dtTemp.Rows[0][TABLES.PatientTransfusionRequirement.RecordStatusCode].ToString().Trim();
			}

			sqlText = "UPDATE " + TABLES.PatientTransfusionRequirement.TableName + " SET PatientGuid = '" + pGuid.ToString() + "' WHERE " + TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + " = '" + recGuid.ToString() + "'";
			UnitTestUtil.RunSQL(sqlText);

			sqlText = "";
			if (recordStatusCode == "A")
			{
				sqlText = "UPDATE " + TABLES.PatientTransfusionRequirement.TableName + " SET RecordStatusCode = 'X', LastUpdateDate = GETUTCDATE() WHERE " + TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + " = '" + recGuid.ToString() + "'";
			}
			else
			{
				sqlText = "UPDATE " + TABLES.PatientTransfusionRequirement.TableName + " SET RecordStatusCode = 'A', LastUpdateDate = GETUTCDATE() WHERE " + TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + " = '" + recGuid.ToString() + "'";
			}

			UnitTestUtil.RunSQL(sqlText);

			DateTime startDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode).AddMinutes(-5);
			DateTime endDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime(UnitTestConfig.TestDivisionCode).AddMinutes(5);

			DataTable dtTest = DAL.AuditTrail.GetTRAudit(startDate, endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetTRAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetTRAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSIAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientSpecialInstructionGuid FROM PatientSpecialInstruction WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.PatientSpecialInstruction.TableName, TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetSIAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetSIAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetSIAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitFinanceAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitFinanceGuid FROM BloodUnitFinance JOIN BloodUnit ON BloodUnit.BloodUnitGuid = BloodUnitFinance.BloodUnitGuid WHERE BloodUnit.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnitFinance.TableName, TABLES.BloodUnitFinance.BloodUnitFinanceGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitFinanceAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitFinanceAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitFinanceAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetLocalSupplierAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 LocalSupplierGuid FROM LocalSupplier WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.LocalSupplier.TableName, TABLES.LocalSupplier.LocalSupplierGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetLocalSupplierAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetLocalSupplierAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetLocalSupplierAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetProductShipperAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ProductShipperGuid FROM ProductShipper WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.ProductShipper.TableName, TABLES.ProductShipper.ProductShipperGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetProductShipperAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetProductShipperAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetProductShipperAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodProductAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ProductShipperGuid FROM ProductShipper WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.ProductShipper.TableName, TABLES.ProductShipper.ProductShipperGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodProductAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodProductAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodProductAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetHcpcsAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 HcpcsAssignmentGuid FROM HcpcsAssignment WHERE UnAssignedDate IS NULL AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.HcpcsAssignment.TableName, TABLES.HcpcsAssignment.HcpcsAssignmentGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetHcpcsAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetHcpcsAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetHcpcsAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetDivisionAudit_Pass()
		{
			this.PerformManualUpdate("UPDATE VamcDivision SET LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			DataTable dtTest = DAL.AuditTrail.GetDivisionAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetDivisionAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetDivisionAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetProductModificationParameterAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ProductModificationParameterGuid FROM ProductModificationParameter WHERE RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.ProductModificationParameter.TableName, TABLES.ProductModificationParameter.ProductModificationParameterGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetProductModificationParameterAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetProductModificationParameterAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetProductModificationParameterAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetAntibodyAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 AntibodyParameterGuid FROM AntibodyParameter WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.AntibodyParameter.TableName, TABLES.AntibodyParameter.AntibodyParameterGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetAntibodyAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetAntibodyAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetAntibodyAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetWorkloadAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 WorkloadProcessGuid FROM WorkloadProcess WHERE RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.WorkloadProcess.TableName, TABLES.WorkloadProcess.WorkloadProcessGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetWorkloadAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetWorkloadAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetWorkloadAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count,"Rows.Count");
		}

		[Test]
		public void GetMSBOSAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 MsbosGuid FROM MSBOS WHERE RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.Msbos.TableName, TABLES.Msbos.MsbosGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetMsbosAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetMSBOSAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetMsbosAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetMSBOSComponentClassAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 MSBOSComponentClass.MsbosGuid FROM MSBOSComponentClass JOIN MSBOS ON Msbos.MsbosGuid = MSBOSComponentClass.MsbosGuid WHERE MSBOSComponentClass.RecordStatusCode = 'A' AND Msbos.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.MsbosComponentClass.TableName, TABLES.Msbos.MsbosGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetMsbosComponentClassAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetMSBOSComponentClassAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetMsbosComponentClassAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTransfusionEffectivenessAudit_Pass()
		{
			DataTable dtTmp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 8 AND SpecimenTestThreshold.RecordStatusCode = 'A' AND SpecimenTestThreshold.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'", false);
			if (dtTmp.Rows.Count == 0)
			{
				this.PerformManualUpdate("INSERT INTO SpecimenTestThreshold (SpecimenTestThresholdGuid, ComponentClassId, VistaLaboratoryTestName,SpecimenTypeCode, ReportTypeId, DivisionCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES(newid(), 1, 'UT_3964', 'B', 8, '" + this.TestDivisionCode + "', 'A', getutcdate(), '" + Common.LogonUser.LogonUserName + "', 9999)");
			}

			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 8 AND SpecimenTestThreshold.RecordStatusCode = 'A' AND SpecimenTestThreshold.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.SpecimenTestThreshold.TableName, TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetTransfusionEffectivenessAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetTransfusionEffectivenessAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetTransfusionEffectivenessAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTransfusionComplicationsAudit_Pass()
		{
			DataTable dtTmp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 7 AND SpecimenTestThreshold.RecordStatusCode = 'A' AND SpecimenTestThreshold.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'", false);
			if (dtTmp.Rows.Count == 0)
			{
				this.PerformManualUpdate("INSERT INTO SpecimenTestThreshold (SpecimenTestThresholdGuid, ComponentClassId, VistaLaboratoryTestName,SpecimenTypeCode, ReportTypeId, DivisionCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES(newid(), 1, 'UT_3964', 'B', 7, '" + this.TestDivisionCode + "', 'A', getutcdate(), '" + Common.LogonUser.LogonUserName + "', 9999)");
			}

			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 7 AND SpecimenTestThreshold.RecordStatusCode = 'A' AND SpecimenTestThreshold.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.SpecimenTestThreshold.TableName, TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetTransfusionComplicationsAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");

		}

		[Test]
		public void GetTransfusionComplicationsAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetTransfusionComplicationsAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetInappropriateRequestIndicatorsAudit_Pass()
		{
			DataTable dtTmp = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 9 AND ComponentClassID IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'", false);
			if (dtTmp.Rows.Count == 0)
			{
				this.PerformManualUpdate("INSERT INTO SpecimenTestThreshold (SpecimenTestThresholdGuid, ComponentClassId, VistaLaboratoryTestName,SpecimenTypeCode, ReportTypeId, DivisionCode, RecordStatusCode, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES(newid(), 1, 'UT_3968', 'B', 9, '" + this.TestDivisionCode + "', 'A', getutcdate(), '" + Common.LogonUser.LogonUserName + "', 9999)");
			}
			
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestThresholdGuid FROM SpecimenTestThreshold WHERE ReportTypeID = 9 AND ComponentClassID IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.SpecimenTestThreshold.TableName, TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetInappropriateRequestIndicatorsAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetInappropriateRequestIndicatorsAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetInappropriateRequestIndicatorsAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetComponentClassAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ComponentClassParameterGuid FROM ComponentClassParameter WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.ComponentClassParameter.TableName, TABLES.ComponentClassParameter.ComponentClassParameterGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetComponentClassAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetComponentClassAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetComponentClassAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetDailyControlAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyControlGuid FROM DailyControl WHERE RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.DailyControl.TableName, TABLES.DailyControl.DailyControlGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetDailyControlAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetDailyControlAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetDailyControlAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count" );
		}

		[Test]
		public void GetReagentTestParameterAudit_Pass()
		{
			this.PerformManualUpdate("UPDATE ReagentTestParameter SET LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "'");

			DataTable dtTest = DAL.AuditTrail.GetReagentTestParameterAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetReagentTestParameterAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetReagentTestParameterAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetConfigureTestingAudit_Pass()
		{	
			this.PerformManualUpdate("UPDATE VamcDivision SET AntibodyScreenDisplayCode = 1, LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
			this.PerformManualUpdate("UPDATE VamcDivision SET LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

			DataTable dtTest = DAL.AuditTrail.GetConfigureTestingAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0,"Rows.Count");
		}

		[Test]
		public void GetConfigureTestingAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetConfigureTestingAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetReagentTypeParameterAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 ReagentTypeParameterGuid FROM ReagentTypeParameter WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.ReagentTypeParameter.TableName, TABLES.ReagentTypeParameter.ReagentTypeParameterGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetReagentTypeParameterAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetReagentTypeParameterAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetReagentTypeParameterAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count" );
		}

		[Test]
		public void GetUserAlertsAudit_Pass()
		{
			this.PerformManualUpdate("UPDATE VamcDivision SET LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

			DataTable dtTest = DAL.AuditTrail.GetUserAlertsAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetUserAlertsAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetUserAlertsAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count" );
		}

		[Test]
		public void GetBloodUnitStatusAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitStatusGuid FROM BloodUnitStatus JOIN BloodUnit ON BloodUnit.BloodUnitGuid = BloodUnitStatus.BloodUnitGuid WHERE BloodUnit.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnitStatus.TableName, TABLES.BloodUnitStatus.BloodUnitStatusGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitStatusAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitStatusAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitStatusAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count,"Rows.Count" );
		}

		[Test]
		public void GetBloodUnitAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnit.TableName, TABLES.BloodUnit.BloodUnitGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		
		[Test]
		public void GetBloodUnitModificationAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitModificationGuid FROM BloodUnitModification WHERE ProductModificationCode = 'P' AND RecordStatusCode = 'A' AND DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnitModification.TableName, TABLES.BloodUnitModification.BloodUnitModificationGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitModificationAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitModificationAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitModificationAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitMediaAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitMediaGuid FROM BloodUnitMedia JOIN BloodUnit ON BloodUnit.BloodUnitGuid = BloodUnitMedia.BloodUnitGuid WHERE DirectedPatientGuid IS NOT NULL AND BloodUnit.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnitMedia.TableName, TABLES.BloodUnitMedia.BloodUnitMediaGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitMediaAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitMediaAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitMediaAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual( 0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitAntigenAudit_Pass()
		{
			this.PerformManualUpdate("UPDATE BloodUnitAntigen SET Comments = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE RowVersion = (SELECT TOP 1 RowVersion FROM BloodUnitAntigen WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "')");

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitAntigenAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitAntigenAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitAntigenAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitTestAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 BloodUnitTestGuid FROM BloodUnitTest JOIN BloodTestType ON BloodTestType.BloodTesttypeID = BloodUnitTest.BloodTestTypeId WHERE BloodTestType.BloodTestName LIKE '%Interp' AND BloodUnitTest.BloodTestTypeId NOT IN (102,104) AND BloodUnitTest.RecordStatusCode = 'A' AND BloodUnitTest.DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "'");

			this.PerformUpdate(TABLES.BloodUnitTest.TableName, TABLES.BloodUnitTest.BloodUnitTestGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetBloodUnitTestAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitTestAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetBloodUnitTestAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetUserRoleAudit_Pass()
		{
			this.PerformManualUpdate("UPDATE VbecsUserDivisionRole SET LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");

			DataTable dtTest = DAL.AuditTrail.GetUserAlertsAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetUserRoleAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetUserRoleAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetInterfaceControlAudit_Pass()
		{
			this.PerformManualUpdate(
				"INSERT INTO InterfaceControl (InterfaceControlId,  InterfaceId, VbecsFacilityId, ProcessingId, AckTimeout, ReTransmitAttempts, InterfaceAdministratorName, "
				+ "PurgeSuccessfulMessage, PurgeUnSuccessfulMessage, InterfaceActiveIndicator, LogEventsIndicator, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId)  "
				+ "VALUES (69, 1, '589', 'I', 0, 0, 'GetInterfaceControlAudit_Pass()', 0, 0, 0, 0, getutcdate(), '" + this.TestDivisionCode + "', 9999)");
			
			this.PerformManualUpdate("UPDATE InterfaceControl SET InterfaceAdministratorName = GETUTCDATE(), LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE VbecsFacilityId = '" + UnitTestConfig.TestDivisionCode + "'");

			DataTable dtTest = DAL.AuditTrail.GetInterfaceControlAudit(this._startDate, this._endDate);

			this.PerformManualUpdate("DELETE FROM InterfaceControl where InterfaceControlId = 69");

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		
		public void GetInterfaceControlAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetInterfaceControlAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetVistALinkControlAudit_Pass()
		{
			this.PerformManualUpdate("Insert INTO VistALinkControl (ServerAppHandle, ServerAlias, VistaIpAddress, VistaPortNumber, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) " +
				" VALUES ('Homer Simpson', 'Commander Cool (aka Me)', '104.78.36.43',4080, getutcdate(),'" + Common.LogonUser.LogonUserName + "',999)");


			this.PerformManualUpdate("UPDATE VistALinkControl SET ServerAlias = 'Max Power', LastUpdateDate = GETUTCDATE(), LastUpdateUser = '" + Common.LogonUser.LogonUserName + "' WHERE ServerAppHandle = 'Homer Simpson'");

			DataTable dtTest = DAL.AuditTrail.GetVistALinkControlAudit(this._startDate, this._endDate);

			this.PerformManualUpdate("DELETE FROM VistALinkControl where ServerAppHandle = 'Homer Simpson'");

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetVistALinkControlAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetVistALinkControlAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetSpecimenTestAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 SpecimenTestGuid FROM SpecimenTest WHERE DivisionCode = '" + Common.LogonUser.LogonUserDivisionCode + "' AND RecordStatusCode = 'A'");

			this.PerformUpdate(TABLES.SpecimenTest.TableName, TABLES.SpecimenTest.SpecimenTestGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetSpecimenTestAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetSpecimenTestAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetSpecimenTestAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetUserAudit_Pass()
		{
			Guid recGuid = DataCreator.GetRecordGuid("SELECT TOP 1 VbecsUserGuid FROM VbecsUser WHERE RecordStatusCode = 'A'");

			this.PerformUpdate(TABLES.VbecsUser.TableName, TABLES.VbecsUser.VbecsUserGuid, recGuid);

			DataTable dtTest = DAL.AuditTrail.GetUserAudit(this._startDate, this._endDate);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
		}

		[Test]
		public void GetUserAudit_Fail()
		{
			DataTable dtTest = DAL.AuditTrail.GetUserAudit(this._invalidStart, this._invalidEnd);
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		/// <summary>
		/// Updates the table's LastUpdateUser field, for where the RecordGuid is the input value
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="fieldName"></param>
		/// <param name="recordGuid"></param>
		private void PerformUpdate(string tableName, string fieldName, Guid recordGuid)
		{
			string sqlText = "UPDATE " + tableName + " SET LastUpdateDate = GETUTCDATE() WHERE " + fieldName + " = '" + recordGuid.ToString() + "'";

			int retValue = UnitTestUtil.RunSQL(sqlText);

			this.RefreshData = true;
		}

		/// <summary>
		/// Updates the table based on the input sql
		/// </summary>
		/// <param name="tableName"></param>
		/// <param name="fieldName"></param>
		/// <param name="recordGuid"></param>
		private void PerformManualUpdate(string sqlText)
		{
			int retValue = UnitTestUtil.RunSQL(sqlText);

			this.RefreshData = true;
		}

	}
}
#endif

